%% cjtcs.cls 1.11   2018-05-23    ToC style file
%------------------------------------------------------------------
% Filename: cjtcs.cls
%
% This documentclass is intended for typesetting articles for the
%
%        Chicago Journal of Theoretical Computer Science.
%
% See http://cjtcs.cs.uchicago.edu/ for further details.
%

%% Version 1.01 fixes version data is provides class.
%%
%% Version 1.1 compliant with pubdetails, options from tocbase 4.4.
%%
%% Version 1.11 compatibility with tocbase 4.44 \bannerhook command.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Declare class, load external packages, and set up metadata
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Need this version of LaTeX atleast (for ClassWarning commands)
\NeedsTeXFormat{LaTeX2e}[1994/06/01] 
\ProvidesClass{cjtcs}[2018/05/23 v1.11 cjtcs style]

% Pass all options along to tocbase:
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{tocbase}}
\PassOptionsToClass{tocmacros}{tocbase}

\newcommand{\toc@shortformarticle}{\@empty}

\ProcessOptions\relax
% Now load article class and handle options.
\LoadClass{tocbase}

\newcommand{\toc@commentsetup}{%
  \renewcommand{\toc@shortformarticle}{comment}
  \renewcommand\toc@bannermodifier{%
    \vspace{1em}{\toc@shortformbannerlayout{COMMENT}}%
    \par \vspace{1em} \hrule \vspace{1pt} \hrule}%
  \renewenvironment{tocaboutauthors}{%
    \ClassWarning{toc}{Use of ABOUT THE AUTHORS discouraged in ToC Comments}\begin{internal@tocaboutauthors}}%
    {\end{internal@tocaboutauthors}}%
}

\newcommand{\toc@notesetup}{%
  \renewcommand{\toc@shortformarticle}{note}
  \renewcommand\toc@bannermodifier{%
    \vspace{1em}{\toc@shortformbannerlayout{NOTE}}%
    \par \vspace{1em} \hrule \vspace{1pt} \hrule}%
}

\newcommand\toc@specialissuesetup{%
  \newcommand{\toc@specialissuebannertext}{\toc@specialissue}%
  \renewcommand\toc@bannerspecialissue{%
    \vspace{1em}{\toc@specialissuelayout{\toc@specialissue}\par}}
}

%% Setup tocdetails defaults
\newcommand{\toc@specialissue}{\@empty}

% Reset journal data
\renewcommand\toc@doiderefaddress{http://dx.doi.org/}
\renewcommand\toc@journalname{Chicago Journal of Theoretical Computer Science}
\renewcommand\toc@journaldoiaddress{\toc@doiderefaddress\toc@journaldoi}
\renewcommand\toc@journaladdress{http://cjtcs.cs.uchicago.edu/}
\renewcommand\toc@journaldoi{10.4086/cjtcs}

% License addresses:
\renewcommand{\toc@cclicenseurl}{http://creativecommons.org/licenses/by/3.0/}
\renewcommand{\toc@licenseurl}{http://cjtcs.cs.uchicago.edu/}

% CJTCS articles start on page 1 unless otherwise specified.
\renewcommand{\toc@declaredfirstpage}{1}

%% cjtcsdetails hooks:
\define@key{pubdet}{specissue}{\renewcommand{\toc@specialissue}{#1}%
  \toc@specialissuesetup}
\define@key{pubdet}{article}[true]{}
\define@key{pubdet}{note}[true]{\toc@notesetup}
\define@key{pubdet}{comment}[true]{\toc@commentsetup}


% argument is a comma seperated list of the type "volume=6,year=8,..."
% If we have details of section we are interested in, process it
\newcommand{\cjtcsdetails}[1]{\setkeys{pubdet}{#1}}

%% Rename some commands for cjtcs use:
\newcommand{\cjtcspdftitle}[1]{\tocpdftitle{#1}}
\newcommand{\cjtcspdfauthor}[1]{\tocpdfauthor{#1}}
\newcommand{\keywords}[1]{\renewcommand{\toc@keywords}{#1}}

\newenvironment{cjtcsauthors}{
  % Define tocinfo environment
  \newenvironment{authorinfo}[1][\@empty]{%
    \begin{verse}
      \ifx##1\@empty\relax\else\hypertarget{author.info.##1}{}\fi
    }{% End of environment
    \end{verse} \filbreak
  } % End of tocinfo
  
  \filbreak % Prefer a page break here rather than later
  \bigskip\noindent
  \ifnum \value{toc@numauthors}>1
  \textsf{AUTHORS}
  \else
  \textsf{AUTHOR}
  \fi
}{%
  \let\authorinfo\relax % Undefine authorinfo
}
%  end tocauthors environment

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Title page components
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\toc@bannermodifier{\relax}
\newcommand\toc@bannerspecialissue{\relax}

\newcommand\toc@specialissuelayout[1]{\fontsize{14}{16}\usefont{OT1}{ptm}{m}{sc}\selectfont{#1}}
\newcommand\toc@shortformbannerlayout[1]{\fontsize{16}{18}\usefont{OT1}{phv}{m}{n}\selectfont{#1}}

\newcommand{\toc@bannerpubdata}
           {\fontsize{11}{13}\usefont{OT1}{ptm}{m}{n}\selectfont
           {\toc@year, Article \toc@number, pages \toc@firstpage--\toc@lastpage}}

\renewcommand\toc@bannertexta%
{\ifex\toc@number\@empty
  \toc@bannerjournalname
 \else
 \toc@bannerjournalname~\toc@bannerpubdata
 \fi}

\setlength{\toc@bannerwidth}{\textwidth}
\addtolength{\toc@bannerwidth}{-5mm}
\renewcommand{\toc@banner}{\toc@bannerhook%
  \begin{minipage}{\toc@bannerwidth}%
    \centering \toc@bannertexta\\ \toc@bannertextb\\
    \vspace{2mm} \hrule\vspace{1pt}\hrule%
   \toc@bannermodifier%
    \toc@bannerspecialissue%
  \end{minipage}}

\renewcommand\toc@keywords\@empty
\renewcommand\toc@classificationbox{%
  \ifex\toc@keywords\@empty%
  {}%
  \else%
  \parbox[t]{\textwidth}{%
    \noindent \textbf{Key words and phrases: }\toc@keywords\par}%
  \fi%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Header and footer initialization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\renewcommand\toc@runningcitation%
{\ifex\toc@number\@empty
 \href{\toc@journaldoiaddress}{\textsc{\toc@journalname}}
\else
\href{\toc@journaldoiaddress}{\textsc{\toc@journalname}} \toc@year,
 Article \toc@number, pages \toc@firstpage--\toc@lastpage
\fi
}
%% These two must be identical, save for the hyperlinks.

\renewcommand\toc@runningcitation@nolink%
{\ifex\toc@number\@empty
  \toc@journaldoiaddress
  \else
  \textsc{\toc@journalname} \toc@year,
 Article \toc@number, pages \toc@firstpage--\toc@lastpage
\fi
}

% Set up the 2ff. page style.
\renewcommand{\ps@headings}{%
 \renewcommand{\@oddhead}
  {\hfil\toc@headerlayout{\toc@runningtitle}\hfil}%    
  \renewcommand{\@evenhead}
  {\hfil\toc@headerlayout{\toc@runningauthor}\hfil}%
  \renewcommand{\@oddfoot}
  {\hfil\toc@footerlayout{\toc@runningcitation}\hfil
    \normalfont\thepage}%
  \renewcommand{\@evenfoot}
  {\hfil\toc@footerlayout{\toc@runningcitation}\hfil
    \normalfont\thepage}%
}

%% Determine actual footer height.
\settoheight\toc@footerheight{\toc@footerlayout{\toc@runningcitation@nolink}}

%% Determine titlepage text area.
\setlength\toc@titlepagecorrection\toc@crboxheight
\addtolength\toc@titlepagecorrection{-\toc@footerheight}

% Define the default page style to be headings.
\pagestyle{headings}
\pagenumbering{arabic}

\AtBeginDocument{%
  {\ifex{\toc@shortformarticle}{\@empty}{%
      \numberwithin{equation}{section}}
    \else{}\fi}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Predefined special issues
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\CATS}{\href{http://cjtcs.cs.uchicago.edu/articles/CATS2009/contents.html}{Special issue for CATS 2009}}
