;; -*- lexical-binding: t; -*-

(TeX-add-style-hook
 "tocbase"
 (lambda ()
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("article" "11pt" "twoside" "letterpaper")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("etoolbox" "") ("newtxtext" "") ("newtxmath" "vvarbb" "varg") ("ifpdf" "") ("amsmath" "") ("amsthm" "") ("amssymb" "") ("fontenc" "T1") ("newpxtext" "") ("newpxmath" "vvarbb" "varg") ("textcomp" "") ("bm" "") ("xcolor" "") ("microtype" "") ("refcount" "") ("keyval" "") ("graphicx" "") ("hyperref" "pagebackref" "hyperfootnotes=false" "colorlinks=true" "urlcolor=externallinkcolor" "linkcolor=internallinkcolor" "filecolor=externallinkcolor" "citecolor=internallinkcolor" "breaklinks=true" "pdfstartview=FitH" "pdfpagelayout=OneColumn") ("hyperxmp" "") ("ccicons" "copyright") ("totpages" "") ("eprint" "")))
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "href")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (TeX-run-style-hooks
    "latex2e"
    "etoolbox"
    "newtxtext"
    "newtxmath"
    "article"
    "art11"
    "ifpdf"
    "amsmath"
    "amsthm"
    "amssymb"
    "fontenc"
    "newpxtext"
    "newpxmath"
    "textcomp"
    "bm"
    "xcolor"
    "microtype"
    "refcount"
    "keyval"
    "graphicx"
    "hyperref"
    "hyperxmp"
    "ccicons"
    "totpages"
    "eprint")
   (TeX-add-symbols
    '("author" ["argument"] 1)
    '("cproblem" 1)
    '("cclass" 1)
    '("exprefsilent" 2)
    '("expeqref" 2)
    '("expref" 2)
    '("titlefootnote" 1)
    '("tockeywords" 1)
    '("tocacm" 1)
    '("tocams" 1)
    '("tocpdfauthor" 1)
    '("tocpdftitle" 1)
    '("runningtitle" 1)
    '("runningauthor" 1)
    '("copyrightauthor" 1)
    '("tocdetails" 1)
    '("ifex" 2)
    "toc"
    "tocat"
    "tocdot"
    "C"
    "R"
    "Q"
    "Z"
    "N"
    "eee"
    "ie"
    "Ie"
    "eg"
    "Eg"
    "phd"
    "msc"
    "bsc"
    "footnotesize"
    "footnoterule"
    "thanks"
    "maketitle"
    "title"
    "date"
    "and"
    "author"
    "abstract"
    "dedication"
    "tocacm"
    "tocams"
    "tockeywords"
    "tocinfo"
    "tocabout")
   (LaTeX-add-labels
    "FirstPage")
   (LaTeX-add-environments
    '("tocabout" LaTeX-env-args ["argument"] 0)
    '("tocinfo" LaTeX-env-args ["argument"] 0)
    '("frontmatter" LaTeX-env-args ["argument"] 0)
    "dedication"
    "tocauthors"
    "tocauthor"
    "internal@tocaboutauthors"
    "tocaboutauthor"
    "tocaboutauthors")
   (LaTeX-add-pagestyles
    "titlepage"
    "headings")
   (LaTeX-add-lengths
    "toc")
   (LaTeX-add-amsthm-newtheorems
    "theorem"
    "lemma"
    "corollary"
    "claim"
    "proposition"
    "fact"
    "conjecture"
    "definition"
    "example"
    "remark"
    "acknowledgement"
    "axiom"
    "case"
    "conclusion"
    "condition"
    "criterion"
    "exercise"
    "notation"
    "problem"
    "question"
    "solution"
    "summary")
   (LaTeX-add-xcolor-definecolors
    "weborange"
    "webblue"
    "internallinkcolor"
    "externallinkcolor"
    "red"))
 :latex)

