from net_3tensor access *;

picture P1, P2;
network N1;
tensor box = N1.add_tensor((40, 30), 40, 30, label="$\langle n, r, n \rangle$", pen=blue);
tensor X = N1.add_tensor((17.5, -20), 17.5, 10, label="$X$", pen=green);
tensor Y = N1.add_tensor((80-17.5, -20), 17.5, 10, label="$Y$", pen=green);
for (int i = 0; i < 4; ++i) {
  N1.join(X.mid + (-15+2.5*i, 0), X.mid + (-15+2.5*i, 30));
  N1.join(Y.mid + (15-2.5*i, 0), Y.mid + (15-2.5*i, 30));
  N1.join(box.mid + (-15+2.5*i, 0), box.mid + (-15+2.5*i, 40));
  N1.join(box.mid + (15-2.5*i, 0), box.mid + (15-2.5*i, 40));
}
for (int i = 0; i < 6; ++i) {
  N1.join(Y.mid + (-15+2.5*i, 0), Y.mid + (-15+2.5*i, 30));
  N1.join(X.mid + (15-2.5*i, 0), X.mid + (15-2.5*i, 30));
}
N1.draw(P1);

network N2;
tensor box = N2.add_tensor((40, 30), 40, 30, label="$\langle c^k, c^k, c^k \rangle$", pen=blue);
tensor X = N2.add_tensor((17.5, -20), 17.5, 10, label="$X$", pen=green);
tensor Y = N2.add_tensor((80-17.5, -20), 17.5, 10, label="$Y$", pen=green);
for (int i = 0; i < 4; ++i) {
  N2.join(X.mid + (-15+2.5*i, 0), X.mid + (-15+2.5*i, 30));
  N2.join(X.mid + (15-2.5*i, 0), X.mid + (15-2.5*i, 30));
  N2.join(Y.mid + (-15+2.5*i+5, 0), Y.mid + (-15+2.5*i+5, 30));
  N2.join(Y.mid + (15-2.5*i, 0), Y.mid + (15-2.5*i, 30));
  N2.join(box.mid + (-15+2.5*i, 0), box.mid + (-15+2.5*i, 40));
  N2.join(box.mid + (15-2.5*i, 0), box.mid + (15-2.5*i, 40));
}
for (int i = 0; i < 2; ++i) {
  tensor I = N2.add_tensor((30+12.5*i, -40-8*i), 5.5, 5.5, label="$I_c$");
  pair xp = (X.mid + (15-2.5*(4+i), 0));
  N2.add_path(I.mid -- (xp.x, I.mid.y) -- xp);
  pair yp = (Y.mid + (-15+2.5*i, 0));
  N2.add_path(I.mid -- (yp.x, I.mid.y) -- yp);
}
N2.draw(P2);
label(P2, "\parbox{2.5cm}{$t-k$ modes,\\each of length $c$}", (57, -45), RightSide, magenta+fontsize(9pt));
label(P2, Label("\}", magenta), (54, -40));
label(P2, "\parbox{3cm}{$k$ modes,\\each of length $c$}", (30, 85), RightSide, magenta+fontsize(9pt));
label(P2, rotate(-90)*Label("\{", magenta), (51, 73));

add(P1, (0, 0));
add(P2, (100, 0));
draw((87, 30-1)--(93, 30-1), p=blue);
draw((87, 30+1)--(93, 30+1), p=blue);
