%% toc.cls 3.24   2014-11-13    ToC style file
%------------------------------------------------------------------
% Filename: toc.cls
%
% This documentclass is intended for typesetting articles for the
%
%                        Theory of Computing.
%
% See http://theoryofcomputing.org for further details.
%
% Search for ``%%% PART'' to find the main parts of this class file.

%% Version 2.26 fixes compilation advertisements.
%%
%% Version 2.27 adds support for ToC NOTE and establishes
%% \numberwithin{equation}{section} only for regular (long-form)
%% submissions; equation numbering for comments, notes is
%% linear. Reinstated backreferencing in the bibliography, as it now
%% points to page numbers.
%%
%% Version 3.0 adds support for banner treatment of special
%% issues. Special issue information is passed through the tocdetails
%% command. Additionally, notes and comments are now handled
%% differently, these alterations to the style are invoked by passing
%% "note" or "comment" to the tocdetails command.
%%
%% Version 3.1 adds support for the RESEARCH SURVEY article type,
%% activated by the keyword "survey" in the tocdetails
%% command. Surveys are treated as regular long-form articles with a
%% extra banner reading "RESEARCH SURVEY."
%%
%% Version 3.2 changes bibliographic layout for the article to include
%% the number, in parentheses, after the volume.
%%
%% Version 3.21 adds a small space between volume and number in banner and footer.
%% Version 3.22 adds codes for three new "Predefined special issues"
%% Version 3.23 fixed versioning information only.
%% Version 3.24 added AR13 and AR14 special issues
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Declare class and load external packages
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Need this version of LaTeX atleast (for ClassWarning commands)
\NeedsTeXFormat{LaTeX2e}[1994/06/01] 
\ProvidesClass{toc}[2013/06/04 v3.23 Theory of Computing]
 
% Pass all options along to tocbase:
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{tocbase}}

\newcommand{\toc@shortformarticle}{\@empty}

\ProcessOptions\relax
% Now load article class and handle options.
\LoadClass{tocbase}

\newcommand{\toc@commentsetup}{%
  \renewcommand{\toc@shortformarticle}{comment}
  \renewcommand\toc@bannermodifier{%
    \vspace{1em}{\toc@subbannerlayout{COMMENT}}%
    \par \vspace{1em} \hrule \vspace{1pt} \hrule}%
  \renewenvironment{tocaboutauthors}{%
    \ClassWarning{toc}{Use of ABOUT THE AUTHORS discouraged in ToC Comments}\begin{internal@tocaboutauthors}}%
    {\end{internal@tocaboutauthors}}%
}

\newcommand{\toc@notesetup}{%
  \renewcommand{\toc@shortformarticle}{note}
  \renewcommand\toc@bannermodifier{%
    \vspace{1em}{\toc@subbannerlayout{NOTE}}%
    \par \vspace{1em} \hrule \vspace{1pt} \hrule}%
}

\newcommand{\toc@surveysetup}{%
 \renewcommand\toc@bannermodifier{%
    \vspace{1em}{\toc@subbannerlayout{RESEARCH SURVEY}}%
    \par \vspace{1em} \hrule \vspace{1pt} \hrule}%
}

\newcommand\toc@specialissuesetup{%
  \newcommand{\toc@specialissuebannertext}{\toc@specialissue}%
  \renewcommand\toc@bannerspecialissue{%
    \vspace{1em}{\toc@specialissuelayout{\toc@specialissue}\par}}
}

%% Setup tocdetails defaults
\newcommand{\toc@specialissue}{\@empty}

%% tocdetails hooks:
\define@key{tocdet}{specissue}{\renewcommand{\toc@specialissue}{#1}%
  \toc@specialissuesetup}
\define@key{tocdet}{article}[true]{}
\define@key{tocdet}{note}[true]{\toc@notesetup}
\define@key{tocdet}{comment}[true]{\toc@commentsetup}
\define@key{tocdet}{survey}[true]{\toc@surveysetup}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%% PART: Title page components
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
\newcommand\toc@bannermodifier{\relax}
\newcommand\toc@bannerspecialissue{\relax}

\newcommand\toc@specialissuelayout[1]{\fontsize{14}{16}\usefont{OT1}{ptm}{m}{sc}\selectfont{#1}}
\newcommand\toc@subbannerlayout[1]{\fontsize{16}{18}\usefont{OT1}{phv}{m}{n}\selectfont{#1}}

\newcommand{\toc@bannerpubdata}
{\fontsize{11}{13}\usefont{OT1}{ptm}{m}{n}\selectfont
  {,\ Volume \toc@volume\,(\toc@number), \toc@year, 
    pp. \toc@firstpage--\toc@lastpage}}

\renewcommand\toc@bannertexta%
{\ifex\toc@volume\@empty
  \toc@bannerjournalname
  \else
  \toc@bannerjournalname\toc@bannerpubdata
  \fi}

\setlength{\toc@bannerwidth}{\textwidth}
\addtolength{\toc@bannerwidth}{-2cm}
\renewcommand{\toc@banner}{\toc@titlepagehook%
  \begin{minipage}{\toc@bannerwidth}%
    \centering \toc@bannertexta\\ \toc@bannertextb\\
    \vspace{2mm} \hrule\vspace{1pt}\hrule%
    \toc@bannermodifier%
    \toc@bannerspecialissue%
  \end{minipage}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%% PART: Header and footer initialization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

\renewcommand\toc@runningcitation%
{\ifex\toc@volume\@empty
  \href{\toc@journaldoiaddress}{\textsc{\toc@journalname}}
  \else
  \href{\toc@journaldoiaddress}{\textsc{\toc@journalname}}\toc@bannerpubdata
  \fi
}
%% These two must be identical, save for the hyperlinks.
\renewcommand\toc@runningcitation@nolink%
{\ifex\toc@volume\@empty
  \textsc{\toc@journalname}
  \else
  \textsc{\toc@journalname}, Volume \toc@volume\ (\toc@year),
  pp. \toc@firstpage--\toc@lastpage
  \fi
}

% Set up the 2ff. page style.
\renewcommand{\ps@headings}{%
  \renewcommand{\@oddhead}
  {\hfil\toc@headerlayout{\toc@runningtitle}\hfil}%    
  \renewcommand{\@evenhead}
  {\hfil\toc@headerlayout{\toc@runningauthor}\hfil}%
  \renewcommand{\@oddfoot}
  {\hfil\toc@footerlayout{\toc@runningcitation}\hfil
    \normalfont\thepage}%
  \renewcommand{\@evenfoot}
  {\hfil\toc@footerlayout{\toc@runningcitation}\hfil
    \normalfont\thepage}%
}

%% Determine actual footer height.
\settoheight\toc@footerheight{\toc@footerlayout{\toc@runningcitation@nolink}}

%% Determine titlepage text area.
\setlength\toc@titlepagecorrection\toc@crboxheight
\addtolength\toc@titlepagecorrection{-\toc@footerheight}

% Define the default page style to be headings.
\pagestyle{headings}
\pagenumbering{arabic}

\AtBeginDocument{%
  {\ifex{\toc@shortformarticle}{\@empty}{%
      \numberwithin{equation}{section}}
    \else{}\fi}}

%% Predefined special issues
\newcommand{\motwani}{Special issue in honor of Rajeev Motwani}
\newcommand{\boolean}{Special issue: Analysis of Boolean Functions}
\newcommand{\approxrandomBC}{Special issue: APPROX-RANDOM 2012}
\newcommand{\approxrandomBD}{Special issue: APPROX-RANDOM 2013}
\newcommand{\approxrandomBE}{Special issue: APPROX-RANDOM 2014}
\newcommand{\itcsBD}{Special issue: ITCS 2013}
%% explanation: BC = 2012 BD = 2013 ... CA = 2020 ...
